import { NextRequest, NextResponse } from 'next/server';
import fs from 'node:fs/promises';
import path from 'node:path';

export const runtime = 'nodejs';

const BASE = path.join(process.cwd(), 'tmp');

export async function GET(_: NextRequest, { params }: { params: { slug: string[] } }) {
  const [type, name] = params.slug;
  const dir = type === 'cutouts' ? 'cutouts' : 'uploads';
  const filePath = path.join(BASE, dir, name);
  try {
    const data = await fs.readFile(filePath);
    const ext = name.split('.').pop()?.toLowerCase();
    const mime = ext === 'png' ? 'image/png' : ext === 'webp' ? 'image/webp' : 'image/jpeg';
    return new NextResponse(data, { headers: { 'Content-Type': mime, 'Cache-Control': 'public, max-age=31536000, immutable' } });
  } catch {
    return new NextResponse('Not Found', { status: 404 });
  }
}
